/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWPastable;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXPDL_20_parser;
import filenet.vw.base.VWString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class VWTextAnnotationDefinition
implements Serializable,
Cloneable,
IVWPastable {
    private static final long serialVersionUID = 464L;
    private VWMapDefinition myMap;
    private Vector associations = new Vector();
    protected int id = -1;
    private Point location = null;
    private String message;
    private Dimension dim = null;
    private boolean minimized = false;
    private Color color = null;
    private String name = null;
    private Object originalNodeGraphicsInfosNode = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-09-17 21:31:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Martin Dwane;4D9996897;mdwane@us.ibm.com (mdwane) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/7 $";
    }

    protected VWTextAnnotationDefinition(VWMapDefinition map, int id, String message, Point location, Dimension dim, boolean minmzd) throws VWException {
        this.setMap(map);
        this.setId(id);
        this.setMessage(message);
        this.setLocation(location);
        this.setDimension(dim);
        this.setMinimized(minmzd);
    }

    protected Object clone() {
        try {
            VWTextAnnotationDefinition clonedAnnotation = (VWTextAnnotationDefinition)super.clone();
            clonedAnnotation.associations = new Vector();
            clonedAnnotation.location = new Point(this.location);
            if (this.dim != null) {
                clonedAnnotation.dim = new Dimension(this.dim);
            }
            clonedAnnotation.color = this.color;
            clonedAnnotation.myMap = null;
            if (this.associations != null) {
                for (int i = 0; i < this.associations.size(); ++i) {
                    VWAssociationDefinition associationDef = (VWAssociationDefinition)this.associations.elementAt(i);
                    if (associationDef == null) continue;
                    VWAssociationDefinition clonedAssociationDef = (VWAssociationDefinition)associationDef.clone();
                    clonedAssociationDef.setTextAnnotation(clonedAnnotation);
                    clonedAnnotation.associations.addElement(clonedAssociationDef);
                }
            }
            return clonedAnnotation;
        }
        catch (CloneNotSupportedException ex) {
        }
        catch (VWException vwEx) {
            vwEx.printStackTrace();
        }
        return null;
    }

    public int getId() throws VWException {
        return this.id;
    }

    protected void setId(int id) throws VWException {
        this.id = id;
    }

    public Point getLocation() throws VWException {
        return this.location;
    }

    public void setLocation(Point location) throws VWException {
        this.location = location;
    }

    public String getMessage() throws VWException {
        return this.message;
    }

    public void setMessage(String message) throws VWException {
        this.message = message;
    }

    public String getName() throws VWException {
        return this.name;
    }

    public void setName(String name) throws VWException {
        this.name = name;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWTextAnnotationDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t<TextAnnotation\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + this.id + "\"\n");
        if (this.name != null) {
            theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        }
        if (this.message != null) {
            theBuffer.append(ATTRIB_INDENT + "Message=\"" + VWXMLHandler.toXMLString(this.message) + "\"\n");
        }
        if (this.getLocation() != null) {
            theBuffer.append(ATTRIB_INDENT + "XCoordinate=\"" + Integer.toString(this.getLocation().x) + "\"\n");
            theBuffer.append(ATTRIB_INDENT + "YCoordinate=\"" + Integer.toString(this.getLocation().y) + "\"\n");
        }
        if (this.getDimension() != null) {
            theBuffer.append(ATTRIB_INDENT + "Width=\"" + Integer.toString(this.getDimension().width) + "\"\n");
            theBuffer.append(ATTRIB_INDENT + "Height=\"" + Integer.toString(this.getDimension().height) + "\"\n");
        }
        if (this.getBgColor() != null) {
            theBuffer.append(ATTRIB_INDENT + "colorRed=\"" + Integer.toString(this.getBgColor().getRed()) + "\"\n");
            theBuffer.append(ATTRIB_INDENT + "colorGreen=\"" + Integer.toString(this.getBgColor().getGreen()) + "\"\n");
            theBuffer.append(ATTRIB_INDENT + "colorBlue=\"" + Integer.toString(this.getBgColor().getBlue()) + "\"\n");
        }
        if (this.minimized) {
            theBuffer.append(ATTRIB_INDENT + "Minimized=\"" + VWXMLHandler.booleanToString(this.minimized) + "\"\n");
        }
        theBuffer.append(" >\n");
        Enumeration Assns = this.associations.elements();
        while (Assns.hasMoreElements()) {
            VWAssociationDefinition element = (VWAssociationDefinition)Assns.nextElement();
            element.toXML(theBuffer);
        }
        theBuffer.append("\t\t</TextAnnotation>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWTextAnnotationDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        VWWorkflowDefinition wfdef = this.getMap().getWorkflow();
        if (wfdef.getWorkflowCollection() == null) {
            throw new VWException("vw.api.VWTextAnnotationDefinitionNullWorkflowCollection", "The XPDL string cannot be created for this text annotation definition. The necessary reference to a containing workflow collection definition is null. \nEnsure that the workflow collection definition containing this text annotation definition is specified.");
        }
        theBuffer.append(indentA + "<Artifact Id=\"Workflow" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.getMap().getName()) + ".Artifact" + this.getId() + "\" ArtifactType=\"Annotation\" TextAnnotation=\"" + VWXMLHandler.toXMLString(this.getMessage()) + "\"");
        if (this.getName() != null) {
            theBuffer.append(" Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.associations == null || this.associations.isEmpty()) {
            theBuffer.append(" fn:workflow=\"" + VWXMLHandler.toXMLString(this.myMap.getWorkflow().getName()) + "\" fn:map=\"" + VWXMLHandler.toXMLString(this.myMap.getName()) + "\"");
        }
        theBuffer.append(">\n");
        VWXPDL_20_parser.writeXPDLNodeGraphicsInfos(this.getLocation(), this.getDimension(), this.getBgColor(), this.minimized, this.getOriginalNodeGraphicsInfosNode(), indentB, theBuffer);
        theBuffer.append(indentA + "</Artifact>\n");
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.id + ":" + this.message + "]";
    }

    public void validate(Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(null, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        if (this.message == null || this.message.length() == 0) {
            theMessage = new VWString("vw.api.VWTextAnnotationDefinitionNoText", "The Annotation contains no text.");
            theError = new VWValidationError(12, 2, null, null, theMessage.toString(), this.getMap().getName(), this.getId());
            validationContext.addValidationError(theError);
        }
        if (this.location == null) {
            theMessage = new VWString("vw.api.VWTextAnnotationDefinitionNoLocation", "The Annotation does not have a location set.");
            theError = new VWValidationError(12, 2, null, null, theMessage.toString(), this.getMap().getName(), this.getId());
            validationContext.addValidationError(theError);
        }
        Enumeration Assns = this.associations.elements();
        while (Assns.hasMoreElements()) {
            VWAssociationDefinition element = (VWAssociationDefinition)Assns.nextElement();
            element.validate(validationContext, this.getMap(), this.id);
        }
    }

    protected VWMapDefinition getMap() {
        return this.myMap;
    }

    protected void setMap(VWMapDefinition theMap) {
        this.myMap = theMap;
    }

    public VWAssociationDefinition createAssociation(int targetId, int targetType) throws VWException {
        switch (targetType) {
            case 1: {
                try {
                    this.myMap.getStep(targetId);
                    break;
                }
                catch (Exception e) {
                    throw new VWException("vw.api.VWTextAnnotationDefinitionBadTargetStep", "Attempt to create association to  non-existent step");
                }
            }
            case 2: {
                try {
                    this.myMap.getRoute(targetId);
                    break;
                }
                catch (Exception e) {
                    throw new VWException("vw.api.VWTextAnnotationDefinitionBadTargetRoute", "Attempt to create association to non-existent route");
                }
            }
            default: {
                throw new VWException("vw.api.VWTextAnnotationDefinitionBadTargetType", "Attempt to create association to invalid target type");
            }
        }
        VWAssociationDefinition newAss = new VWAssociationDefinition(this, this.myMap.associationIdGenerator.getNextId(), targetId, targetType);
        Enumeration existingAssns = this.associations.elements();
        while (existingAssns.hasMoreElements()) {
            VWAssociationDefinition element = (VWAssociationDefinition)existingAssns.nextElement();
            if (!newAss.equals(element)) continue;
            throw new VWException("vw.api.VWTextAnnotationDefinitionAssociationAlreadyExists", "Attempt to create an association that already exists");
        }
        this.associations.add(newAss);
        return newAss;
    }

    protected VWAssociationDefinition internalCreateAssociation(int targetId, int targetType) throws VWException {
        VWAssociationDefinition newAss = new VWAssociationDefinition(this, this.myMap.associationIdGenerator.getNextId(), targetId, targetType);
        Enumeration existingAssns = this.associations.elements();
        while (existingAssns.hasMoreElements()) {
            VWAssociationDefinition element = (VWAssociationDefinition)existingAssns.nextElement();
            if (!newAss.equals(element)) continue;
            throw new VWException("vw.api.VWTextAnnotationDefinitionAssociationAlreadyExists", "Attempt to create an association that already exists");
        }
        this.associations.add(newAss);
        return newAss;
    }

    public void deleteAssociation(int targetId, int targetType) throws VWException {
        VWAssociationDefinition assToDelete = new VWAssociationDefinition(this, this.myMap.associationIdGenerator.getNextId(), targetId, targetType);
        this.associations.remove(assToDelete);
    }

    public void deleteAllAssociations() throws VWException {
        this.associations.clear();
    }

    public VWAssociationDefinition[] getAllAssociations() throws VWException {
        Object[] retVal = new VWAssociationDefinition[this.associations.size()];
        this.associations.copyInto(retVal);
        return retVal;
    }

    public VWAssociationDefinition getAssociation(int targetId, int targetType) throws VWException {
        VWAssociationDefinition assnToRetrieve = new VWAssociationDefinition(this, this.myMap.associationIdGenerator.getNextId(), targetId, targetType);
        int idx = this.associations.indexOf(assnToRetrieve);
        if (idx == -1) {
            throw new VWException("vw.api.VWTextAnnotation.AssociationNotFound", "No association found with target ID {0} and type {1}.", String.valueOf(targetId), VWAssociationTargetType.typeToString(targetType));
        }
        return (VWAssociationDefinition)this.associations.elementAt(idx);
    }

    public Dimension getDimension() {
        return this.dim;
    }

    public void setDimension(Dimension dim) {
        this.dim = dim;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    public Color getBgColor() {
        return this.color;
    }

    public void setBgColor(Color color) {
        this.color = color;
    }

    protected void setOriginalNodeGraphicsInfosNode(Object obj) {
        this.originalNodeGraphicsInfosNode = obj;
    }

    protected Object getOriginalNodeGraphicsInfosNode() {
        return this.originalNodeGraphicsInfosNode;
    }
}

